#pragma once

#include "parameters.hpp"

#include <src/logic/interface/get_contacts.hpp>
#include <src/server/stream.hpp>
#include <src/error_code.hpp>

namespace collie::server {

class GetContactsHandler {
public:
    GetContactsHandler(const std::shared_ptr<const logic::GetContacts>& impl);

    expected<void> operator ()(const Uid& uid, const ContactIds& contactIds, const StreamPtr& stream,
            const TaskContextPtr& context) const;

private:
    std::shared_ptr<const logic::GetContacts> impl;
};

} // namespace collie::server
