#include "get_contacts_with_tag_handler.hpp"

#include <src/logic/interface/types/reflection/existing_contacts.hpp>
#include <src/server/respond.hpp>
#include <src/server/utils.hpp>

namespace collie::server {

GetContactsWithTagHandler::GetContactsWithTagHandler(
        const std::shared_ptr<const logic::GetContactsWithTag>& impl)
    : impl(impl) {
}

expected<void> GetContactsWithTagHandler::operator()(const Uid& uid, const TagId& tagId,
        const StreamPtr& stream, const TaskContextPtr& context) const {
    const auto& request = stream->request();
    const auto& params{request->url.params};
    const std::string offsetKey{"offset"};
    const std::string limitKey{"limit"};
    return respondWithJson(stream, (*impl)(context, uid.value, tagId.value, getOrNone(params, offsetKey),
            getOrNone(params, limitKey)));
}

} // namespace collie::server
