#pragma once

#include "parameters.hpp"

#include <src/logic/interface/get_contacts_with_tag.hpp>
#include <src/server/stream.hpp>

namespace collie::server {

class GetContactsWithTagHandler {
public:
    GetContactsWithTagHandler(const std::shared_ptr<const logic::GetContactsWithTag>& impl);

    expected<void> operator()(const Uid& uid, const TagId& tagId, const StreamPtr& stream,
            const TaskContextPtr& context) const;

private:
    std::shared_ptr<const logic::GetContactsWithTag> impl;
};

} // namespace collie::server
