#include "get_emails_handler.hpp"

#include <src/log.hpp>
#include <src/logic/interface/types/reflection/get_emails_result.hpp>
#include <src/server/respond.hpp>
#include <src/server/utils.hpp>

namespace collie::server {

GetEmailsHandler::GetEmailsHandler(const std::shared_ptr<const logic::GetEmails>& impl)
    : impl(impl) {
}

expected<void> GetEmailsHandler::operator()(const Uid& uid, const TagIds& tagIds, const StreamPtr& stream,
        const TaskContextPtr& context) const {
    const auto& request = stream->request();
    const auto& params{request->url.params};
    const std::string mixinKey{"mixin"};
    return respondWithJson(stream, (*impl)(context, uid.value, tagIds.value, getOrNone(params, mixinKey)));
}

} // namespace collie::server
