#pragma once

#include "parameters.hpp"

#include <src/logic/interface/get_emails.hpp>
#include <src/server/stream.hpp>

namespace collie::server {

class GetEmailsHandler {
public:
    GetEmailsHandler(const std::shared_ptr<const logic::GetEmails>& impl);

    expected<void> operator()(const Uid& uid, const TagIds& tagIds, const StreamPtr& stream,
            const TaskContextPtr& context) const;

private:
    std::shared_ptr<const logic::GetEmails> impl;
};

} // namespace collie::server
