#include "get_shared_contacts_count_from_list_handler.hpp"

#include <src/logic/interface/types/reflection/list_contacts_counter.hpp>
#include <src/server/respond.hpp>
#include <src/server/utils.hpp>

namespace collie::server {

GetSharedContactsCountFromListHandler::GetSharedContactsCountFromListHandler(const std::shared_ptr<
        const logic::GetSharedContactsCountFromList>& impl)
    : impl(impl) {
}

expected<void> GetSharedContactsCountFromListHandler::operator()(const Uid& uid, const ListId& listId,
        const StreamPtr& stream, const TaskContextPtr& context) const {
    const std::string sharedWithEmailsKey{"shared_with_emails"};
    const auto& request = stream->request();
    const auto sharedWithEmails{getOrNone(request->url.params, sharedWithEmailsKey)};
    std::string_view withSharedWithEmails{"1"};
    auto sharedWithEmailsValue{false};
    if (sharedWithEmails && (*sharedWithEmails == withSharedWithEmails)) {
        sharedWithEmailsValue = true;
    }

    return respondWithJson(stream, (*impl)(context, uid.value, listId.value, sharedWithEmailsValue));
}

} // namespace collie::server
