#pragma once

#include "parameters.hpp"
#include <src/logic/interface/get_shared_contacts_count_from_list.hpp>
#include <src/server/stream.hpp>
#include <src/task_context.hpp>
#include <src/expected.hpp>
#include <memory>

namespace collie::server {

class GetSharedContactsCountFromListHandler {
public:
    GetSharedContactsCountFromListHandler(const std::shared_ptr<const logic::GetSharedContactsCountFromList>& impl);
    expected<void> operator()(const Uid& uid, const ListId& listId, const StreamPtr& stream, const TaskContextPtr& context) const;
private:
    std::shared_ptr<const logic::GetSharedContactsCountFromList> impl;
};

} // namespace collie::server