#include "get_shared_contacts_from_list_handler.hpp"

#include <src/logic/interface/types/reflection/existing_contacts.hpp>
#include <src/server/respond.hpp>
#include <src/server/utils.hpp>

namespace collie::server {

GetSharedContactsFromListHandler::GetSharedContactsFromListHandler(
        const std::shared_ptr<const logic::GetSharedContactsFromList>& impl)
    : impl(impl) {
}

expected<void> GetSharedContactsFromListHandler::operator()(const Uid& uid, const ListId& listId,
        const ContactIds& contactIds, const StreamPtr& stream, const TaskContextPtr& context) const {
    const auto& request = stream->request();
    const auto& params{request->url.params};
    const std::string offsetKey{"offset"};
    const std::string limitKey{"limit"};
    const std::string sharedWithEmailsKey{"shared_with_emails"};
    const auto sharedWithEmails{getOrNone(params, sharedWithEmailsKey)};
    std::string_view withSharedWithEmails{"1"};
    auto sharedWithEmailsValue{false};
    if (sharedWithEmails && (*sharedWithEmails == withSharedWithEmails)) {
        sharedWithEmailsValue = true;
    }

    return respondWithJson(stream, (*impl)(context, uid.value, contactIds.value, listId.value,
            getOrNone(params, offsetKey), getOrNone(params, limitKey), sharedWithEmailsValue));
}

} // namespace collie::server
