#pragma once

#include "parameters.hpp"

#include <src/logic/interface/get_shared_contacts_from_list.hpp>
#include <src/server/stream.hpp>

namespace collie::server {

class GetSharedContactsFromListHandler {
public:
    GetSharedContactsFromListHandler(const std::shared_ptr<const logic::GetSharedContactsFromList>& impl);
    expected<void> operator()(const Uid& uid, const ListId& listId, const ContactIds& contactIds,
            const StreamPtr& stream, const TaskContextPtr& context) const;

private:
    std::shared_ptr<const logic::GetSharedContactsFromList> impl;
};

} // namespace collie::server
