#include "get_shared_lists_handler.hpp"
#include <src/logic/interface/types/reflection/existing_shared_lists.hpp>
#include <src/server/respond.hpp>

namespace collie::server {

GetSharedListsHandler::GetSharedListsHandler(const std::shared_ptr<const logic::GetSharedLists>& impl)
    : impl(impl) {
}
expected<void> GetSharedListsHandler::operator()(const Uid& uid, const StreamPtr& stream,
        const TaskContextPtr& context) const {
    return respondWithJson(stream, (*impl)(context, uid.value));
}

} // namespace collie::server
