#pragma once

#include "parameters.hpp"
#include <src/logic/interface/get_shared_lists.hpp>
#include <src/server/stream.hpp>
#include <src/task_context.hpp>
#include <src/expected.hpp>
#include <memory>

namespace collie::server {

class GetSharedListsHandler {
public:
    GetSharedListsHandler(const std::shared_ptr<const logic::GetSharedLists>& impl);
    expected<void> operator()(const Uid& uid, const StreamPtr& stream, const TaskContextPtr& context) const;
private:
    std::shared_ptr<const logic::GetSharedLists> impl;
};

} // namespace collie::server
