#include "get_tags_handler.hpp"

#include <src/server/respond.hpp>

#include <src/logic/interface/types/reflection/existing_tags.hpp>

namespace collie::server {

GetTagsHandler::GetTagsHandler(const std::shared_ptr<const logic::GetTags>& impl)
    : impl(impl) {}

expected<void> GetTagsHandler::operator ()(const Uid& uid, const StreamPtr& stream,
        const TaskContextPtr& context) const {
    return respondWithJson(stream, (*impl)(context, uid.value));
}

} // namespace collie::server
