#pragma once

#include "parameters.hpp"

#include <src/logic/interface/get_tags.hpp>
#include <src/server/stream.hpp>
#include <src/error_code.hpp>

namespace collie::server {

class GetTagsHandler {
public:
    GetTagsHandler(const std::shared_ptr<const logic::GetTags>& impl);

    expected<void> operator ()(const Uid& uid, const StreamPtr& stream, const TaskContextPtr& context) const;

private:
    std::shared_ptr<const logic::GetTags> impl;
};

} // namespace collie::server
