#pragma once

#include <src/server/status.hpp>
#include <src/server/stream.hpp>
#include <src/expected.hpp>
#include <src/task_context.hpp>

#include <yamail/data/serialization/yajl.h>

namespace collie::server {

struct NotImplemented {
    expected<void> operator ()(const StreamPtr& stream, const TaskContextPtr&) const {
        using yamail::data::serialization::toJson;
        stream->set_code(ymod_webserver::codes::bad_request);
        stream->set_content_type("application/json");
        stream->result_body(toJson(
            StatusError {Error::notImplemented, "Resource handler is not implemented yet"}
        ).str());
        return {};
    }

    template <class T1>
    expected<void> operator ()(const T1&, const StreamPtr& stream, const TaskContextPtr& context) const {
        return this->operator ()(stream, context);
    }

    template <class T1, class T2>
    expected<void> operator ()(const T1&, const T2&, const StreamPtr& stream, const TaskContextPtr& context) const {
        return this->operator ()(stream, context);
    }
};

} // namespace collie::server
