#include "remove_contacts_handler.hpp"
#include "reflection/revision_result.hpp"

#include <src/server/respond.hpp>

namespace collie::server {

RemoveContactsHandler::RemoveContactsHandler(const std::shared_ptr<const logic::RemoveContacts>& impl)
    : impl(impl) {}

expected<void> RemoveContactsHandler::operator ()(const Uid& uid, const ContactIds& contactIds,
        const StreamPtr& stream, const TaskContextPtr& context) const {
    return respondWithJson(stream, (*impl)(context, uid.value, contactIds.value));
}

} // namespace collie::server
