#pragma once

#include "parameters.hpp"

#include <src/logic/interface/remove_contacts.hpp>
#include <src/server/stream.hpp>

namespace collie::server {

class RemoveContactsHandler {
public:
    RemoveContactsHandler(const std::shared_ptr<const logic::RemoveContacts>& impl);

    expected<void> operator ()(const Uid& uid, const ContactIds& contactIds, const StreamPtr& stream,
            const TaskContextPtr& context) const;

private:
    std::shared_ptr<const logic::RemoveContacts> impl;
};

} // namespace collie::server
