#include "remove_tag_handler.hpp"
#include "reflection/revision_result.hpp"

#include <src/server/respond.hpp>

namespace collie::server {

RemoveTagHandler::RemoveTagHandler(const std::shared_ptr<const logic::RemoveTag>& impl)
    : impl(impl) {}

expected<void> RemoveTagHandler::operator ()(const Uid& uid, const TagId& tagId, const StreamPtr& stream,
        const TaskContextPtr& context) const {
    return respondWithJson(stream, (*impl)(context, uid.value, tagId.value));
}

} // namespace collie::server
