#pragma once

#include "parameters.hpp"

#include <src/logic/interface/remove_tag.hpp>
#include <src/server/stream.hpp>

namespace collie::server {

class RemoveTagHandler {
public:
    RemoveTagHandler(const std::shared_ptr<const logic::RemoveTag>& impl);

    expected<void> operator ()(const Uid& uid, const TagId& tagId, const StreamPtr& stream,
            const TaskContextPtr& context) const;

private:
    std::shared_ptr<const logic::RemoveTag> impl;
};

} // namespace collie::server
