#include "restore_handler.hpp"

#include <src/server/respond.hpp>
#include <src/server/status.hpp>

namespace collie::server {

RestoreHandler::RestoreHandler(const std::shared_ptr<const logic::Restore>& impl)
    : impl(impl) {}

expected<void> RestoreHandler::operator ()(const Uid& uid, const Revision& revision, const StreamPtr& stream,
        const TaskContextPtr& context) const {
    return respondWithJson(stream, (*impl)(context, uid.value, revision.value));
}

} // namespace collie::server
