#pragma once

#include "parameters.hpp"

#include <src/logic/interface/restore.hpp>
#include <src/server/stream.hpp>
#include <src/error_code.hpp>

namespace collie::server {

class RestoreHandler {
public:
    RestoreHandler(const std::shared_ptr<const logic::Restore>& impl);

    expected<void> operator ()(const Uid& uid, const Revision& revision, const StreamPtr& stream,
            const TaskContextPtr& context) const;

private:
    std::shared_ptr<const logic::Restore> impl;
};

} // namespace collie::server
