#pragma once

#include "parameters.hpp"

#include <src/logic/interface/sync_organizations.hpp>
#include <src/server/stream.hpp>

namespace collie::server {

class SyncOrganizationsHandler {
public:
    SyncOrganizationsHandler(const std::shared_ptr<const logic::SyncOrganizations>& impl);

    expected<void> operator()(const StreamPtr& stream, const TaskContextPtr& context) const;

private:
    std::shared_ptr<const logic::SyncOrganizations> impl;
};

} // namespace collie::server
