#include "update_contacts_handler.hpp"
#include "reflection/revision_result.hpp"

#include <src/server/parse_request_body.hpp>
#include <src/server/respond.hpp>

#include <src/logic/interface/types/reflection/updated_contacts.hpp>

#include <src/log.hpp>

namespace collie::server {

UpdateContactsHandler::UpdateContactsHandler(const std::shared_ptr<const logic::UpdateContacts>& impl)
    : impl(impl) {}

expected<void> UpdateContactsHandler::operator ()(const Uid& uid, const StreamPtr& stream,
        const TaskContextPtr& context) const {
    using yamail::data::deserialization::fromJson;
    using yamail::data::serialization::toJson;

    const auto request = stream->request();
    const std::string body(request->raw_body.begin(), request->raw_body.end());

    return parseRequestBody<logic::UpdatedContacts>(body, context->logger(),
            "failed to parse updated contacts"_s)
        .bind([&] (auto&& updatedContacts) {
            return respondWithJson(stream, (*impl)(context, uid.value, std::move(updatedContacts)));
        });
}

} // namespace collie::server
