#pragma once

#include "parameters.hpp"

#include <src/logic/interface/update_contacts.hpp>
#include <src/server/stream.hpp>
#include <src/error_code.hpp>

namespace collie::server {

class UpdateContactsHandler {
public:
    UpdateContactsHandler(const std::shared_ptr<const logic::UpdateContacts>& impl);

    expected<void> operator ()(const Uid& uid, const StreamPtr& stream, const TaskContextPtr& context) const;

private:
    std::shared_ptr<const logic::UpdateContacts> impl;
};

} // namespace collie::server
