#include "update_tag_handler.hpp"
#include "reflection/revision_result.hpp"

#include <src/server/parse_request_body.hpp>
#include <src/server/respond.hpp>

#include <src/logic/interface/types/reflection/updated_tag.hpp>

#include <src/log.hpp>

namespace collie::server {

UpdateTagHandler::UpdateTagHandler(const std::shared_ptr<const logic::UpdateTag>& impl)
    : impl(impl) {}

expected<void> UpdateTagHandler::operator ()(const Uid& uid, const TagId& tagId,
        const StreamPtr& stream, const TaskContextPtr& context) const {
    using yamail::data::deserialization::fromJson;
    using yamail::data::serialization::toJson;

    const auto request = stream->request();
    const std::string body(request->raw_body.begin(), request->raw_body.end());

    return parseRequestBody<logic::UpdatedTag>(body, context->logger(), "failed to parse updated tag"_s)
        .bind([&] (auto&& updatedTag) {
            return respondWithJson(stream, (*impl)(context, uid.value, tagId.value, std::move(updatedTag)));
        });
}

} // namespace collie::server
