#pragma once

#include "parameters.hpp"

#include <src/logic/interface/update_tag.hpp>
#include <src/server/stream.hpp>

namespace collie::server {

class UpdateTagHandler {
public:
    UpdateTagHandler(const std::shared_ptr<const logic::UpdateTag>& impl);

    expected<void> operator ()(const Uid& uid, const TagId& tagId, const StreamPtr& stream,
            const TaskContextPtr& context) const;

private:
    std::shared_ptr<const logic::UpdateTag> impl;
};

} // namespace collie::server
