#pragma once

#include "error_category.hpp"

#include <src/error_code.hpp>
#include <src/log.hpp>

#include <boost/hana/string.hpp>

#include <string>

namespace collie::server {

template <class T, class Logger, char ... c>
auto parseRequestBody(const std::string& value, const Logger& logger, boost::hana::string<c ...> errorMessage)
        -> expected<T> {
    using yamail::data::deserialization::fromJson;
    try {
        return fromJson<T>(value);
    } catch (const std::exception& e) {
        logException(logger, e,
            log::message=boost::hana::to<const char*>(errorMessage),
            log::request_body=value
        );
        return make_unexpected(error_code(
            Error::invalidRequestBodyFormat,
            boost::hana::to<const char*>(errorMessage)
        ));
    }
}

} // namespace collie::server
