#pragma once

#include <boost/hana/size.hpp>
#include <boost/hana/tuple.hpp>

#include <optional>

namespace router {

namespace hana = boost::hana;

namespace detail {

template <std::size_t low, std::size_t high, class Result, class Range, class Value,
    class Less, class Equal, class Function>
constexpr std::enable_if_t<(high == low), std::optional<Result>> binary_search_impl(
        const Range&, const Value&, Less&&, Equal&&, Function&&) {
    return {};
}

template <std::size_t low, std::size_t high, class Result, class Range, class Value,
    class Less, class Equal, class Function>
constexpr std::enable_if_t<(high - low == 1), std::optional<Result>> binary_search_impl(
        const Range& range, const Value& value, Less&&, Equal&& equal, Function&& function) {
    if (equal(value, hana::at_c<low>(range))) {
        return function(hana::at_c<low>(range));
    } else {
        return {};
    }
}

template <std::size_t low, std::size_t high, class Result, class Range, class Value,
    class Less, class Equal, class Function>
constexpr std::enable_if_t<(high - low >= 2), std::optional<Result>> binary_search_impl(
        const Range& range, const Value& value, Less&& less, Equal&& equal, Function&& function) {
    if (less(value, hana::at_c<hana::size_c<(low + high) / 2>>(range))) {
        return binary_search_impl<low, (low + high) / 2, Result>(range, value, std::forward<Less>(less),
            std::forward<Equal>(equal), std::forward<Function>(function));
    } else {
        return binary_search_impl<(low + high) / 2, high, Result>(range, value, std::forward<Less>(less),
            std::forward<Equal>(equal), std::forward<Function>(function));
    }
}

} // namespace detail

template <class Result, class ... T, class Value, class Less, class Equal, class Function>
constexpr std::optional<Result> binary_search(const hana::tuple<T ...>& range,
        const Value& value, Less&& less, Equal&& equal, Function&& function) {
    return detail::binary_search_impl<std::size_t(0), sizeof ... (T), Result>(
        range,
        value,
        std::forward<Less>(less),
        std::forward<Equal>(equal),
        std::forward<Function>(function)
    );
}

struct BinarySearch {
    template <class Result, class ... T, class Value, class Less, class Equal, class Function>
    static constexpr std::optional<Result> apply(const hana::tuple<T ...>& range,
            const Value& value, Less&& less, Equal&& equal, Function&& function) {
        return binary_search<Result>(
            range,
            value,
            std::forward<Less>(less),
            std::forward<Equal>(equal),
            std::forward<Function>(function)
        );
    }
};

} // namespace router
