#pragma once

#include "error.hpp"

#include <system_error>
#include <type_traits>

namespace std {

template <>
struct is_error_code_enum<router::Error> : true_type {};

} // namespace std

namespace router {

class ErrorCategory final : public std::error_category {
public:
    const char* name() const noexcept override {
        return "router::ErrorCategory";
    }

    std::string message(int value) const override {
        switch (static_cast<Error>(value)) {
            case Error::method_not_found:
                return "method is not found";
            case Error::location_not_found:
                return "location is not found";
        }
        return "unknown error code: " + std::to_string(value);
    }

    static const ErrorCategory& instance() {
        static const ErrorCategory errorCategory;
        return errorCategory;
    }
};

inline std::error_code make_error_code(Error ec) {
    return std::error_code(static_cast<int>(ec), ErrorCategory::instance());
}

} // namespace router
