#include "server.hpp"
#include "error_category.hpp"

#include <src/logic/error.hpp>

namespace collie::server {

ymod_webserver::codes::code getYmodWebserverCode(const router::Error value) {
    switch (value) {
        case router::Error::location_not_found:
            return ymod_webserver::codes::not_found;
        case router::Error::method_not_found:
            return ymod_webserver::codes::method_not_allowed;
    }
    return ymod_webserver::codes::internal_server_error;
}

ymod_webserver::codes::code getYmodWebserverCode(const Error value) {
    switch (value) {
        case Error::ok:
            return ymod_webserver::codes::ok;
        case Error::routeError:
        case Error::notImplemented:
        case Error::invalidParameter:
        case Error::invalidRequestBodyFormat:
        case Error::invalidRequestBodyContent:
            return ymod_webserver::codes::bad_request;
        case Error::invalidTvm2Ticket:
            return ymod_webserver::codes::unauthorized;
        case Error::unclassifiedError:
            return ymod_webserver::codes::internal_server_error;
    }
    return ymod_webserver::codes::internal_server_error;
}

ymod_webserver::codes::code getYmodWebserverCode(const collie::logic::Error value) {
    switch (value) {
        case collie::logic::Error::ok:
            return ymod_webserver::codes::ok;
        case collie::logic::Error::userNotFound:
        case collie::logic::Error::invalidUid:
        case collie::logic::Error::badRequest:
            return ymod_webserver::codes::bad_request;
        case collie::logic::Error::invalidDatabaseResult:
            return ymod_webserver::codes::internal_server_error;
    }
    return ymod_webserver::codes::internal_server_error;
}

ymod_webserver::codes::code getYmodWebserverCode(const sharpei::client::Errors value) {
    switch (value) {
        case sharpei::client::Errors::UidNotFound:
            return ymod_webserver::codes::bad_request;
        default:
            return ymod_webserver::codes::internal_server_error;
    }
}

ymod_webserver::codes::code getYmodWebserverCode(const mail_errors::error_code& value) {
    if (value.category() == ErrorCategory::instance()) {
        return getYmodWebserverCode(static_cast<Error>(value.value()));
    } else if (value.category() == collie::logic::ErrorCategory::instance()) {
        return getYmodWebserverCode(static_cast<collie::logic::Error>(value.value()));
    } else if (value.category() == sharpei::client::getErrorCategory()) {
        return getYmodWebserverCode(static_cast<sharpei::client::Errors>(value.value()));
    }

    return ymod_webserver::codes::internal_server_error;
}

Error getError(const mail_errors::error_code& value) {
    if (value.category() == ErrorCategory::instance()) {
        return static_cast<Error>(value.value());
    }
    return Error::unclassifiedError;
}

} // namespace collie::server
