#pragma once

#include "error.hpp"

#include <yamail/data/reflection/reflection.h>

#include <string>

namespace collie::server {

struct StatusOk {
    std::string status {"ok"};
};

struct StatusError {
    Error code;
    std::string message;
    std::string status {"error"};
};

} // namespace collie::server

BOOST_FUSION_ADAPT_STRUCT(collie::server::StatusOk,
    status
)

YREFLECTION_ADAPT_ADT(collie::server::StatusError,
    YREFLECTION_ROMEMBER(std::string, status)
    YREFLECTION_ENUM_MEMBER(collie::server::Error, code)
    YREFLECTION_ROMEMBER(std::string, message)
)
