#include "utils.hpp"

namespace collie::server {

static const std::string xRequestIdKey("x-request-id");

std::string_view getRequestId(const Stream& stream) {
    if (const auto result = getOrNone(stream.request()->headers, xRequestIdKey)) {
        return *result;
    }
    return std::string_view("-");
}

} // namespace collie::server
