#pragma once

#include "stream.hpp"

#include <optional>
#include <string_view>

namespace collie::server {

template <class Map, class Key>
inline std::optional<std::string_view> getOrNone(const Map& map, const Key& key) {
    const auto it = map.find(key);
    return it == map.end() ? std::nullopt : std::optional<std::string_view>(it->second);
}

std::string_view getRequestId(const Stream& stream);

} // namespace collie::server
