#pragma once

#include "cid.hpp"
#include "name.hpp"
#include "tid.hpp"

#include <src/types/email_with_tags.hpp>

#include <optional>
#include <string>
#include <vector>

namespace collie::services::abook {

struct Birthdate {
    std::optional<std::int64_t> day;
    std::optional<std::int64_t> month;
    std::optional<std::int64_t> month1;
    std::optional<std::int64_t> year;
};

struct Phone {
    std::optional<std::string> value;
};

struct Photo {
    std::optional<std::string> partial_url;
};

struct YaDirectory {
    std::optional<std::int64_t> org_id;
    std::optional<std::string> org_name;
    std::optional<std::string> type;
    std::optional<std::int64_t> id;
};

struct Contact {
    Cid cid;
    std::optional<std::vector<Tid>> tag;
    std::optional<Name> name;
    std::optional<std::vector<EmailWithTags>> email;
    std::optional<std::string> nickname;
    std::optional<Birthdate> birthdate;
    std::optional<std::string> description;
    std::optional<std::vector<Phone>> phone;
    std::optional<std::vector<Photo>> photo;
    std::optional<std::string> company;
    std::optional<std::string> department;
    std::optional<std::string> title;
    std::optional<std::string> summary;
    std::optional<YaDirectory> ya_directory;
};

struct ContactEmail {
    Cid cid;
    std::optional<std::int64_t> id;
    std::optional<std::vector<Tid>> tags;
    std::optional<Name> name;
    std::optional<std::string> email;
    std::optional<std::string> photo_partial_url;
    std::optional<std::string> company;
    std::optional<std::string> department;
    std::optional<std::string> title;
    std::optional<std::string> summary;
    std::optional<YaDirectory> ya_directory;
};

} // namespace collie::services::abook
