#pragma once

#include "contact.hpp"

#include <boost/fusion/adapted/struct/define_struct.hpp>

#include <variant>

BOOST_FUSION_DEFINE_STRUCT((collie)(services)(abook), SearchContactsGroupedResult,
    (std::vector<collie::services::abook::Contact>, contact)
    (std::int64_t, count)
)

BOOST_FUSION_DEFINE_STRUCT((collie)(services)(abook), SearchContactsUngroupedResult,
    (std::vector<collie::services::abook::ContactEmail>, contact)
    (std::int64_t, count)
)

namespace collie::services::abook {

using SearchContactsResult = std::variant<SearchContactsGroupedResult, SearchContactsUngroupedResult>;

} // namespace collie::services::abook
