#pragma once

#include "types/change_type.hpp"
#include "types/contacts_email_with_tags.hpp"
#include "types/create_contacts_email_result.hpp"
#include "types/create_contacts_result.hpp"
#include "types/create_contacts_user_result.hpp"
#include "types/directory_entity_type.hpp"
#include "types/list_type.hpp"
#include "types/new_contact.hpp"
#include "types/new_contacts_email.hpp"
#include "types/tag_type.hpp"
#include "types/updated_contact.hpp"
#include "types/updated_contacts_email.hpp"
#include "types/user_type.hpp"
#include "types/vcard_format.hpp"

#include <ozo/type_traits.h>

namespace collie::services::db::contacts {

using BaseOidMap = decltype(ozo::register_types<
        ChangeType,
        NewContact,
        std::vector<NewContact>,
        NewContactsEmail,
        std::vector<NewContactsEmail>,
        TagType,
        VcardFormat,
        CreateContactsResult,
        UpdatedContact,
        std::vector<UpdatedContact>,
        UpdatedContactsEmail,
        std::vector<UpdatedContactsEmail>,
        CreateContactsEmailResult,
        ConstUserType,
        ContactsEmailWithTags,
        std::vector<ContactsEmailWithTags>,
        DirectoryEntityType,
        DirectoryEntity,
        std::vector<DirectoryEntity>,
        DirectoryEntityIdAndType,
        std::vector<DirectoryEntityIdAndType>,
        CreateContactsUserResult,
        ListType
    >());

struct OidMap : BaseOidMap {};

} // namespace collie::services::db::contacts

namespace ozo {

template <>
struct is_oid_map<collie::services::db::contacts::OidMap> : std::true_type {};

} // namespace ozo
