#pragma once

#include "types/create_contacts_user_result.hpp"
#include "types/reflection/carddav_contact_row.hpp"
#include "types/reflection/change_row.hpp"
#include "types/reflection/contact_email_id_row.hpp"
#include "types/reflection/contact_id_tag_id_row.hpp"
#include "types/reflection/create_contacts_email_result.hpp"
#include "types/reflection/create_contacts_result.hpp"
#include "types/reflection/created_list_row.hpp"
#include "types/reflection/created_tag_row.hpp"
#include "types/reflection/directory_entity.hpp"
#include "types/reflection/directory_entity_id_and_type.hpp"
#include "types/reflection/directory_entity_row.hpp"
#include "types/reflection/email_id_tag_id_row.hpp"
#include "types/reflection/existing_contact_row.hpp"
#include "types/reflection/existing_email_row.hpp"
#include "types/reflection/existing_shared_list_row.hpp"
#include "types/reflection/existing_tag_row.hpp"
#include "types/reflection/new_contact.hpp"
#include "types/reflection/new_contacts_email.hpp"
#include "types/reflection/updated_contact.hpp"
#include "types/reflection/updated_contacts_email.hpp"
#include "types/reflection/shared_list_row.hpp"
#include "types/reflection/subscribed_list.hpp"
#include "types/list_type.hpp"
#include "types/tag_id.hpp"
#include "types/user_type.hpp"

#include <src/services/db/user_type.hpp>

#include <ozo/query_conf.h>

#include <boost/hana/define_struct.hpp>
#include <boost/hana/string.hpp>
#include <boost/hana/core/to.hpp>

namespace collie::services::db::contacts::query {

using namespace boost::hana::literals;

struct IsUserExists {
    static constexpr auto name = "IsUserExists"_s;

    BOOST_HANA_DEFINE_STRUCT(IsUserExists,
        (std::int64_t, uid),
        (ConstUserType, user_type)
    );

    using parameters_type = IsUserExists;
    using result_type = std::tuple<bool>;
};

struct CreateContactsUser {
    static constexpr auto name = "CreateContactsUser"_s;

    BOOST_HANA_DEFINE_STRUCT(CreateContactsUser,
        (std::int64_t, uid),
        (ConstUserType, user_type),
        (std::string, x_request_id)
    );

    using parameters_type = CreateContactsUser;
    using result_type = CreateContactsUserResult;
};


struct RestoreContacts {
    static constexpr auto name = "RestoreContacts"_s;

    BOOST_HANA_DEFINE_STRUCT(RestoreContacts,
        (std::int64_t, uid),
        (std::int64_t, revision),
        (std::string, x_request_id)
    );

    using parameters_type = RestoreContacts;
    using result_type = std::tuple<std::int64_t>;
};

struct GetChanges {
    static constexpr auto name = "GetChanges"_s;

    BOOST_HANA_DEFINE_STRUCT(GetChanges,
        (std::int64_t, uid)
    );

    using parameters_type = GetChanges;
    using result_type = ChangeRow;
};

struct GetContacts {
    static constexpr auto name = "GetContacts"_s;

    BOOST_HANA_DEFINE_STRUCT(GetContacts,
        (std::int64_t, uid),
        (ConstUserType, user_type),
        (std::vector<std::int64_t>, contact_ids),
        (std::vector<std::int64_t>, list_ids),
        (std::optional<std::int64_t>, offset),
        (std::optional<std::int64_t>, limit)
    );

    using parameters_type = GetContacts;
    using result_type = ExistingContactRow;
};

struct GetContactsWithEmails {
    static constexpr auto name = "GetContactsWithEmails"_s;

    BOOST_HANA_DEFINE_STRUCT(GetContactsWithEmails,
        (std::int64_t, uid),
        (ConstUserType, user_type),
        (std::vector<std::int64_t>, contact_ids),
        (std::vector<std::int64_t>, list_ids),
        (std::optional<std::int64_t>, offset),
        (std::optional<std::int64_t>, limit)
    );

    using parameters_type = GetContactsWithEmails;
    using result_type = ExistingContactRow;
};

struct GetContactsByTagId {
    static constexpr auto name = "GetContactsByTagId"_s;

    BOOST_HANA_DEFINE_STRUCT(GetContactsByTagId,
        (std::int64_t, uid),
        (std::int64_t, tag_id),
        (std::optional<std::int64_t>, offset),
        (std::optional<std::int64_t>, limit)
    );

    using parameters_type = GetContactsByTagId;
    using result_type = ExistingContactRow;
};

struct RemoveContacts {
    static constexpr auto name = "RemoveContacts"_s;

    BOOST_HANA_DEFINE_STRUCT(RemoveContacts,
        (std::int64_t, uid),
        (ConstUserType, user_type),
        (std::vector<std::int64_t>, contact_ids),
        (std::string, x_request_id)
    );

    using parameters_type = RemoveContacts;
    using result_type = std::int64_t;
};

struct GetUserTypeLists {
    friend constexpr auto get_raw_query_name(const GetUserTypeLists&) noexcept {
        return "GetUserTypeLists"_s;
    }

    BOOST_HANA_DEFINE_STRUCT(GetUserTypeLists,
        (std::int64_t, uid)
    );

    using parameters_type = GetUserTypeLists;
    using result_type = ExistingSharedListRow;
};

struct CreateTag {
    friend constexpr auto get_raw_query_name(const CreateTag&) noexcept {
        return "CreateTag"_s;
    }

    BOOST_HANA_DEFINE_STRUCT(CreateTag,
        (std::int64_t, uid),
        (std::string, name),
        (std::string, x_request_id)
    );

    using parameters_type = CreateTag;
    using result_type = CreatedTagRow;
};

struct GetTags {
    static constexpr auto name = "GetTags"_s;

    BOOST_HANA_DEFINE_STRUCT(GetTags,
        (std::int64_t, uid)
    );

    using parameters_type = GetTags;
    using result_type = ExistingTagRow;
};

struct RemoveTag {
    static constexpr auto name = "RemoveTag"_s;

    BOOST_HANA_DEFINE_STRUCT(RemoveTag,
        (std::int64_t, uid),
        (ConstUserType, user_type),
        (std::int64_t, tag_id),
        (std::string, x_request_id)
    );

    using parameters_type = RemoveTag;
    using result_type = std::int64_t;
};

struct UpdateTag {
    friend constexpr auto get_raw_query_name(const UpdateTag&) noexcept {
        return "UpdateTag"_s;
    }

    BOOST_HANA_DEFINE_STRUCT(UpdateTag,
        (std::int64_t, uid),
        (std::int64_t, tag_id),
        (std::optional<std::string>, name),
        (std::string, x_request_id),
        (std::optional<std::int64_t>, revision)
    );

    using parameters_type = UpdateTag;
    using result_type = std::int64_t;
};

struct GetContactsCount {
    friend constexpr auto get_raw_query_name(const GetContactsCount&) noexcept {
        return "GetContactsCount"_s;
    }

    BOOST_HANA_DEFINE_STRUCT(GetContactsCount,
        (std::int64_t, uid),
        (ConstUserType, user_type),
        (std::vector<std::int64_t>, list_ids)
    );

    using parameters_type = GetContactsCount;
    using result_type = std::int64_t;
};

struct GetContactsWithEmailsCount {
    friend constexpr auto get_raw_query_name(const GetContactsWithEmailsCount&) noexcept {
        return "GetContactsWithEmailsCount"_s;
    }

    BOOST_HANA_DEFINE_STRUCT(GetContactsWithEmailsCount,
        (std::int64_t, uid),
        (ConstUserType, user_type),
        (std::vector<std::int64_t>, list_ids)
    );

    using parameters_type = GetContactsWithEmailsCount;
    using result_type = std::int64_t;
};

struct CreateContacts {
    friend constexpr auto get_raw_query_name(const CreateContacts&) noexcept {
        return "CreateContacts"_s;
    }

    BOOST_HANA_DEFINE_STRUCT(CreateContacts,
        (std::int64_t, uid),
        (ConstUserType, user_type),
        (std::vector<NewContact>, contacts),
        (std::string, x_request_id)
    );

    using parameters_type = CreateContacts;
    using result_type = std::tuple<CreateContactsResult>;
};

struct CreateContactsEmails {
    friend constexpr auto get_raw_query_name(const CreateContactsEmails&) noexcept {
        return "CreateContactsEmails"_s;
    }

    BOOST_HANA_DEFINE_STRUCT(CreateContactsEmails,
        (std::int64_t, uid),
        (ConstUserType, user_type),
        (std::vector<NewContactsEmail>, emails),
        (std::string, x_request_id)
    );

    using parameters_type = CreateContactsEmails;
    using result_type = std::tuple<CreateContactsEmailResult>;
};

struct TagContacts {
    friend constexpr auto get_raw_query_name(const TagContacts&) noexcept {
        return "TagContacts"_s;
    }

    BOOST_HANA_DEFINE_STRUCT(TagContacts,
        (std::int64_t, uid),
        (ConstUserType, user_type),
        (std::int64_t, tag_id),
        (std::vector<std::int64_t>, contact_ids),
        (std::string, x_request_id)
    );

    using parameters_type = TagContacts;
    using result_type = std::int64_t;
};

struct TagContactsEmails {
    friend constexpr auto get_raw_query_name(const TagContactsEmails&) noexcept {
        return "TagContactsEmails"_s;
    }

    BOOST_HANA_DEFINE_STRUCT(TagContactsEmails,
        (std::int64_t, uid),
        (ConstUserType, user_type),
        (std::int64_t, tag_id),
        (std::vector<std::int64_t>, email_ids),
        (std::string, x_request_id)
    );

    using parameters_type = TagContactsEmails;
    using result_type = std::int64_t;
};

struct AcquireRevision {
    friend constexpr auto get_raw_query_name(const AcquireRevision&) noexcept {
        return "AcquireRevision"_s;
    }

    BOOST_HANA_DEFINE_STRUCT(AcquireRevision,
        (std::int64_t, uid),
        (ConstUserType, user_type)
    );

    using parameters_type = AcquireRevision;
    using result_type = std::int64_t;
};

struct UpdateContacts {
    friend constexpr auto get_raw_query_name(const UpdateContacts&) noexcept {
        return "UpdateContacts"_s;
    }

    BOOST_HANA_DEFINE_STRUCT(UpdateContacts,
        (std::int64_t, uid),
        (ConstUserType, user_type),
        (std::vector<UpdatedContact>, contacts),
        (std::string, x_request_id),
        (std::optional<std::int64_t>, revision)
    );

    using parameters_type = UpdateContacts;
    using result_type = std::int64_t;
};

struct GetContactsEmailIdsByContactsIds {
    friend constexpr auto get_raw_query_name(const GetContactsEmailIdsByContactsIds&) noexcept {
        return "GetContactsEmailIdsByContactsIds"_s;
    }

    BOOST_HANA_DEFINE_STRUCT(GetContactsEmailIdsByContactsIds,
        (std::int64_t, uid),
        (ConstUserType, user_type),
        (std::vector<std::int64_t>, contacts_ids)
    );

    using parameters_type = GetContactsEmailIdsByContactsIds;
    using result_type = ContactIdEmailIdEmailRow;
};

struct GetContactsIdsByContactsEmailIds {
    friend constexpr auto get_raw_query_name(const GetContactsIdsByContactsEmailIds&) noexcept {
        return "GetContactsIdsByContactsEmailIds"_s;
    }

    BOOST_HANA_DEFINE_STRUCT(GetContactsIdsByContactsEmailIds,
        (std::int64_t, uid),
        (ConstUserType, user_type),
        (std::vector<std::int64_t>, email_ids)
    );

    using parameters_type = GetContactsIdsByContactsEmailIds;
    using result_type = ContactIdEmailIdRow;
};

struct GetContactsEmailIdsByTagIds {
    friend constexpr auto get_raw_query_name(const GetContactsEmailIdsByTagIds&) noexcept {
        return "GetContactsEmailIdsByTagIds"_s;
    }

    BOOST_HANA_DEFINE_STRUCT(GetContactsEmailIdsByTagIds,
        (std::int64_t, uid),
        (ConstUserType, user_type),
        (std::vector<std::int64_t>, tag_ids)
    );

    using parameters_type = GetContactsEmailIdsByTagIds;
    using result_type = std::int64_t;
};

struct GetContactsEmailIdsByContactIdAndTagIds {
    friend constexpr auto get_raw_query_name(const GetContactsEmailIdsByContactIdAndTagIds&) noexcept {
        return "GetContactsEmailIdsByContactIdAndTagIds"_s;
    }

    BOOST_HANA_DEFINE_STRUCT(GetContactsEmailIdsByContactIdAndTagIds,
        (std::int64_t, uid),
        (ConstUserType, user_type),
        (std::int64_t, contact_id),
        (std::vector<std::int64_t>, tag_ids)
    );

    using parameters_type = GetContactsEmailIdsByContactIdAndTagIds;
    using result_type = std::int64_t;
};

struct GetContactsEmailsByTagIds {
    friend constexpr auto get_raw_query_name(const GetContactsEmailsByTagIds&) noexcept {
        return "GetContactsEmailsByTagIds"_s;
    }

    BOOST_HANA_DEFINE_STRUCT(GetContactsEmailsByTagIds,
        (std::int64_t, uid),
        (ConstUserType, user_type),
        (std::vector<std::int64_t>, tag_ids)
    );

    using parameters_type = GetContactsEmailsByTagIds;
    using result_type = ExistingEmailRow;
};

struct GetEmailIdsTagIdsByEmailIds {
    friend constexpr auto get_raw_query_name(const GetEmailIdsTagIdsByEmailIds&) noexcept {
        return "GetEmailIdsTagIdsByEmailIds"_s;
    }

    BOOST_HANA_DEFINE_STRUCT(GetEmailIdsTagIdsByEmailIds,
        (std::int64_t, uid),
        (ConstUserType, user_type),
        (std::vector<std::int64_t>, email_ids)
    );

    using parameters_type = GetEmailIdsTagIdsByEmailIds;
    using result_type = EmailIdTagIdRow;
};

struct GetContactIdsByTagIds {
    friend constexpr auto get_raw_query_name(const GetContactIdsByTagIds&) noexcept {
        return "GetContactIdsByTagIds"_s;
    }

    BOOST_HANA_DEFINE_STRUCT(GetContactIdsByTagIds,
        (std::int64_t, uid),
        (ConstUserType, user_type),
        (std::vector<std::int64_t>, tag_ids)
    );

    using parameters_type = GetContactIdsByTagIds;
    using result_type = std::int64_t;
};

struct GetContactIdsTagIdsByContactIds {
    friend constexpr auto get_raw_query_name(const GetContactIdsTagIdsByContactIds&) noexcept {
        return "GetContactIdsTagIdsByContactIds"_s;
    }

    BOOST_HANA_DEFINE_STRUCT(GetContactIdsTagIdsByContactIds,
        (std::int64_t, uid),
        (ConstUserType, user_type),
        (std::vector<std::int64_t>, contact_ids)
    );

    using parameters_type = GetContactIdsTagIdsByContactIds;
    using result_type = ContactIdTagIdRow;
};

struct UpdateContactsEmails {
    friend constexpr auto get_raw_query_name(const UpdateContactsEmails&) noexcept {
        return "UpdateContactsEmails"_s;
    }

    BOOST_HANA_DEFINE_STRUCT(UpdateContactsEmails,
        (std::int64_t, uid),
        (ConstUserType, user_type),
        (std::vector<UpdatedContactsEmail>, emails),
        (std::string, x_request_id),
        (std::optional<std::int64_t>, revision)
    );

    using parameters_type = UpdateContactsEmails;
    using result_type = std::int64_t;
};

struct RemoveContactsEmails {
    friend constexpr auto get_raw_query_name(const RemoveContactsEmails&) noexcept {
        return "RemoveContactsEmails"_s;
    }

    BOOST_HANA_DEFINE_STRUCT(RemoveContactsEmails,
        (std::int64_t, uid),
        (ConstUserType, user_type),
        (std::vector<std::int64_t>, email_ids),
        (std::string, x_request_id)
    );

    using parameters_type = RemoveContactsEmails;
    using result_type = std::int64_t;
};

struct UntagContacts {
    friend constexpr auto get_raw_query_name(const UntagContacts&) noexcept {
        return "UntagContacts"_s;
    }

    BOOST_HANA_DEFINE_STRUCT(UntagContacts,
        (std::int64_t, uid),
        (ConstUserType, user_type),
        (std::int64_t, tag_id),
        (std::vector<std::int64_t>, contact_ids),
        (std::string, x_request_id)
    );

    using parameters_type = UntagContacts;
    using result_type = std::int64_t;
};

struct UntagContactsCompletely {
    friend constexpr auto get_raw_query_name(const UntagContactsCompletely&) noexcept {
        return "UntagContactsCompletely"_s;
    }

    BOOST_HANA_DEFINE_STRUCT(UntagContactsCompletely,
        (std::int64_t, uid),
        (ConstUserType, user_type),
        (std::vector<std::int64_t>, contact_ids),
        (std::string, x_request_id)
    );

    using parameters_type = UntagContactsCompletely;
    using result_type = std::int64_t;
};

struct UntagContactsEmails {
    friend constexpr auto get_raw_query_name(const UntagContactsEmails&) noexcept {
        return "UntagContactsEmails"_s;
    }

    BOOST_HANA_DEFINE_STRUCT(UntagContactsEmails,
        (std::int64_t, uid),
        (ConstUserType, user_type),
        (std::int64_t, tag_id),
        (std::vector<std::int64_t>, email_ids),
        (std::string, x_request_id)
    );

    using parameters_type = UntagContactsEmails;
    using result_type = std::int64_t;
};

struct UntagContactsEmailsCompletely {
    friend constexpr auto get_raw_query_name(const UntagContactsEmailsCompletely&) noexcept {
        return "UntagContactsEmailsCompletely"_s;
    }

    BOOST_HANA_DEFINE_STRUCT(UntagContactsEmailsCompletely,
        (std::int64_t, uid),
        (ConstUserType, user_type),
        (std::vector<std::int64_t>, email_ids),
        (std::string, x_request_id)
    );

    using parameters_type = UntagContactsEmailsCompletely;
    using result_type = std::int64_t;
};

struct GetDefaultListId {
    friend constexpr auto get_raw_query_name(const GetDefaultListId&) noexcept {
        return "GetDefaultListId"_s;
    }

    BOOST_HANA_DEFINE_STRUCT(GetDefaultListId,
        (std::int64_t, uid),
        (ConstUserType, user_type)
    );

    using parameters_type = GetDefaultListId;
    using result_type = std::int64_t;
};

struct GetOnlyNewEmails {
    friend constexpr auto get_raw_query_name(const GetOnlyNewEmails&) noexcept {
        return "GetOnlyNewEmails"_s;
    }

    BOOST_HANA_DEFINE_STRUCT(GetOnlyNewEmails,
        (std::int64_t, uid),
        (ConstUserType, user_type),
        (std::vector<std::string>, emails)
    );

    using parameters_type = GetOnlyNewEmails;
    using result_type = std::string;
};

struct GetContactsByTagNameAndTagTypeAndUris {
    friend constexpr auto get_raw_query_name(const GetContactsByTagNameAndTagTypeAndUris&) noexcept {
        return "GetContactsByTagNameAndTagTypeAndUris"_s;
    }

    BOOST_HANA_DEFINE_STRUCT(GetContactsByTagNameAndTagTypeAndUris,
        (std::int64_t, uid),
        (ConstUserType, user_type),
        (TagType, tag_type),
        (std::string, tag_name),
        (std::vector<std::string>, uris)
    );

    using parameters_type = GetContactsByTagNameAndTagTypeAndUris;
    using result_type = CarddavContactRow;
};

struct GetTagIdByTagNameAndTagType {
    friend constexpr auto get_raw_query_name(const GetTagIdByTagNameAndTagType&) noexcept {
        return "GetTagIdByTagNameAndTagType"_s;
    }

    BOOST_HANA_DEFINE_STRUCT(GetTagIdByTagNameAndTagType,
        (std::int64_t, uid),
        (ConstUserType, user_type),
        (TagType, tag_type),
        (std::string, tag_name)
    );

    using parameters_type = GetTagIdByTagNameAndTagType;
    using result_type = TagId;
};

struct GetSharedContacts {
    friend constexpr auto get_raw_query_name(const GetSharedContacts&) noexcept {
        return "GetSharedContacts"_s;
    }

    BOOST_HANA_DEFINE_STRUCT(GetSharedContacts,
        (std::int64_t, uid),
        (ConstUserType, user_type),
        (std::int64_t, client_uid),
        (ConstUserType, client_user_type),
        (std::vector<std::int64_t>, list_ids)
    );

    using parameters_type = GetSharedContacts;
    using result_type = ExistingContactRow;
};

struct SubscribeToContactsList {
    friend constexpr auto get_raw_query_name(const SubscribeToContactsList&) noexcept {
        return "SubscribeToContactsList"_s;
    }

    BOOST_HANA_DEFINE_STRUCT(SubscribeToContactsList,
        (std::int64_t, uid),
        (ConstUserType, user_type),
        (std::int64_t, list_id),
        (std::int64_t, owner_user_id),
        (ConstUserType, owner_user_type),
        (std::int64_t, owner_list_id),
        (std::string, x_request_id)
    );

    using parameters_type = SubscribeToContactsList;
    using result_type = std::int64_t;
};

struct RevokeSubscribedContactsList {
    friend constexpr auto get_raw_query_name(const RevokeSubscribedContactsList&) noexcept {
        return "RevokeSubscribedContactsList"_s;
    }

    BOOST_HANA_DEFINE_STRUCT(RevokeSubscribedContactsList,
        (std::int64_t, uid),
        (ConstUserType, user_type),
        (std::int64_t, list_id),
        (std::int64_t, owner_user_id),
        (ConstUserType, owner_user_type),
        (std::int64_t, owner_list_id),
        (std::string, x_request_id)
    );

    using parameters_type = RevokeSubscribedContactsList;
    using result_type = std::int64_t;
};

struct ShareContactsList {
    friend constexpr auto get_raw_query_name(const ShareContactsList&) noexcept {
        return "ShareContactsList"_s;
    }

    BOOST_HANA_DEFINE_STRUCT(ShareContactsList,
        (std::int64_t, uid),
        (ConstUserType, user_type),
        (std::int64_t, list_id),
        (std::int64_t, client_user_id),
        (ConstUserType, client_user_type),
        (std::string, x_request_id)
    );

    using parameters_type = ShareContactsList;
    using result_type = std::int64_t;
};

struct RevokeContactsList {
    friend constexpr auto get_raw_query_name(const RevokeContactsList&) noexcept {
        return "RevokeContactsList"_s;
    }

    BOOST_HANA_DEFINE_STRUCT(RevokeContactsList,
        (std::int64_t, uid),
        (ConstUserType, user_type),
        (std::int64_t, list_id),
        (std::int64_t, client_user_id),
        (ConstUserType, client_user_type),
        (std::string, x_request_id)
    );

    using parameters_type = RevokeContactsList;
    using result_type = std::int64_t;
};

struct GetSubscribedList {
    friend constexpr auto get_raw_query_name(const GetSubscribedList&) noexcept {
        return "GetSubscribedList"_s;
    }

    BOOST_HANA_DEFINE_STRUCT(GetSubscribedList,
        (std::int64_t, uid),
        (ConstUserType, user_type),
        (std::int64_t, list_id)
    );

    using parameters_type = GetSubscribedList;
    using result_type = SubscribeList;
};

struct GetSubscribedLists {
    friend constexpr auto get_raw_query_name(const GetSubscribedLists&) noexcept {
        return "GetSubscribedLists"_s;
    }

    BOOST_HANA_DEFINE_STRUCT(GetSubscribedLists,
        (std::int64_t, uid),
        (ConstUserType, user_type)
    );

    using parameters_type = GetSubscribedLists;
    using result_type = SubscribeList;
};

struct GetDirectoryEntities {
    friend constexpr auto get_raw_query_name(const GetDirectoryEntities&) noexcept {
        return "GetDirectoryEntities"_s;
    }

    BOOST_HANA_DEFINE_STRUCT(GetDirectoryEntities,
        (std::int64_t, uid),
        (ConstUserType, user_type)
    );

    using parameters_type = GetDirectoryEntities;
    using result_type = DirectoryEntityRow;
};

struct CreateDirectoryEntities {
    friend constexpr auto get_raw_query_name(const CreateDirectoryEntities&) noexcept {
        return "CreateDirectoryEntities"_s;
    }

    BOOST_HANA_DEFINE_STRUCT(CreateDirectoryEntities,
        (std::int64_t, uid),
        (ConstUserType, user_type),
        (std::vector<DirectoryEntity>, directory_entities),
        (std::string, x_request_id)
    );

    using parameters_type = CreateDirectoryEntities;
    using result_type = std::int64_t;
};

struct RemoveDirectoryEntities {
    friend constexpr auto get_raw_query_name(const RemoveDirectoryEntities&) noexcept {
        return "RemoveDirectoryEntities"_s;
    }

    BOOST_HANA_DEFINE_STRUCT(RemoveDirectoryEntities,
        (std::int64_t, uid),
        (ConstUserType, user_type),
        (std::vector<DirectoryEntityIdAndType>, directory_entities),
        (std::string, x_request_id)
    );

    using parameters_type = RemoveDirectoryEntities;
    using result_type = std::int64_t;
};

struct GetSharedContactsCount {
    friend constexpr auto get_raw_query_name(const GetSharedContactsCount&) noexcept {
        return "GetSharedContactsCount"_s;
    }

    BOOST_HANA_DEFINE_STRUCT(GetSharedContactsCount,
        (std::int64_t, uid),
        (ConstUserType, user_type),
        (std::int64_t, client_uid),
        (ConstUserType, client_user_type),
        (std::vector<std::int64_t>, list_ids)
    );

    using parameters_type = GetSharedContactsCount;
    using result_type = std::int64_t;
};

struct GetSharedContactsCountWithEmails {
    friend constexpr auto get_raw_query_name(const GetSharedContactsCountWithEmails&) noexcept {
        return "GetSharedContactsCountWithEmails"_s;
    }

    BOOST_HANA_DEFINE_STRUCT(GetSharedContactsCountWithEmails,
        (std::int64_t, uid),
        (ConstUserType, user_type),
        (std::int64_t, client_uid),
        (ConstUserType, client_user_type),
        (std::vector<std::int64_t>, list_ids)
    );

    using parameters_type = GetSharedContactsCountWithEmails;
    using result_type = std::int64_t;
};

struct GetSharedLists {
    friend constexpr auto get_raw_query_name(const GetSharedLists&) noexcept {
        return "GetSharedLists"_s;
    }

    BOOST_HANA_DEFINE_STRUCT(GetSharedLists,
        (std::int64_t, uid),
        (ConstUserType, user_type)
    );

    using parameters_type = GetSharedLists;
    using result_type = SharedListRow;
};

struct CreateContactsList {
    friend constexpr auto get_raw_query_name(const CreateContactsList&) noexcept {
        return "CreateContactsList"_s;
    }

    BOOST_HANA_DEFINE_STRUCT(CreateContactsList,
        (std::int64_t, uid),
        (ConstUserType, user_type),
        (std::string, name),
        (ListType, type),
        (std::string, x_request_id)
    );

    using parameters_type = CreateContactsList;
    using result_type = CreatedListRow;
};

struct DeleteContactsList {
    friend constexpr auto get_raw_query_name(const DeleteContactsList&) noexcept {
        return "DeleteContactsList"_s;
    }

    BOOST_HANA_DEFINE_STRUCT(DeleteContactsList,
        (std::int64_t, uid),
        (ConstUserType, user_type),
        (std::int64_t, list_id),
        (std::string, x_request_id)
    );

    using parameters_type = DeleteContactsList;
    using result_type = std::int64_t;
};

struct GetSubscribedListIdsByOwner {
    friend constexpr auto get_raw_query_name(const GetSubscribedListIdsByOwner&) noexcept {
        return "GetSubscribedListIdsByOwner"_s;
    }

    BOOST_HANA_DEFINE_STRUCT(GetSubscribedListIdsByOwner,
        (std::int64_t, uid),
        (ConstUserType, user_type),
        (std::int64_t, owner_uid),
        (ConstUserType, owner_user_type)
    );

    using parameters_type = GetSubscribedListIdsByOwner;
    using result_type = std::int64_t;
};

struct GetTagById {
    friend constexpr auto get_raw_query_name(const GetTagById&) noexcept {
        return "GetTagById"_s;
    }

    BOOST_HANA_DEFINE_STRUCT(GetTagById,
        (std::int64_t, uid),
        (ConstUserType, user_type),
        (std::int64_t, tag_id)
    );

    using parameters_type = GetTagById;
    using result_type = ExistingTagRow;
};

struct GetContactIdsByListIds {
    friend constexpr auto get_raw_query_name(const GetContactIdsByListIds&) noexcept {
        return "GetContactIdsByListIds"_s;
    }

    BOOST_HANA_DEFINE_STRUCT(GetContactIdsByListIds,
        (std::int64_t, uid),
        (ConstUserType, user_type),
        (std::vector<std::int64_t>, list_ids),
        (std::vector<std::int64_t>, contact_ids)
    );

    using parameters_type = GetContactIdsByListIds;
    using result_type = std::int64_t;
};

struct PurgeContactsUser {
    friend constexpr auto get_raw_query_name(const PurgeContactsUser&) noexcept {
        return "PurgeContactsUser"_s;
    }

    BOOST_HANA_DEFINE_STRUCT(PurgeContactsUser,
        (std::int64_t, uid),
        (ConstUserType, user_type),
        (bool, force),
        (bool, full)
    );

    using parameters_type = PurgeContactsUser;
    using result_type = void;
};

} // namespace collie::services::db::contacts::query
