#pragma once

#include "query.hpp"

#include <src/services/db/query_repository.hpp>

namespace collie::services::db::contacts {

inline auto makeBaseQueryRepository(const std::string& path) {
    return db::makeQueryRepository<
            query::IsUserExists,
            query::RestoreContacts,
            query::GetChanges,
            query::GetContacts,
            query::GetContactsWithEmails,
            query::GetContactsByTagId,
            query::RemoveContacts,
            query::GetUserTypeLists,
            query::CreateTag,
            query::GetTags,
            query::RemoveTag,
            query::UpdateTag,
            query::GetContactsCount,
            query::GetContactsWithEmailsCount,
            query::CreateContacts,
            query::CreateContactsEmails,
            query::TagContacts,
            query::TagContactsEmails,
            query::AcquireRevision,
            query::UpdateContacts,
            query::GetContactsEmailIdsByContactsIds,
            query::GetContactsIdsByContactsEmailIds,
            query::GetContactsEmailIdsByTagIds,
            query::GetContactsEmailIdsByContactIdAndTagIds,
            query::GetContactsEmailsByTagIds,
            query::GetEmailIdsTagIdsByEmailIds,
            query::GetContactIdsByTagIds,
            query::GetContactIdsTagIdsByContactIds,
            query::UpdateContactsEmails,
            query::RemoveContactsEmails,
            query::UntagContacts,
            query::UntagContactsCompletely,
            query::UntagContactsEmails,
            query::UntagContactsEmailsCompletely,
            query::GetDefaultListId,
            query::GetOnlyNewEmails,
            query::GetContactsByTagNameAndTagTypeAndUris,
            query::GetTagIdByTagNameAndTagType,
            query::GetSharedContacts,
            query::SubscribeToContactsList,
            query::RevokeSubscribedContactsList,
            query::ShareContactsList,
            query::RevokeContactsList,
            query::GetSubscribedList,
            query::GetSubscribedLists,
            query::GetDirectoryEntities,
            query::CreateDirectoryEntities,
            query::RemoveDirectoryEntities,
            query::CreateContactsUser,
            query::GetSharedContactsCount,
            query::GetSharedContactsCountWithEmails,
            query::GetSharedLists,
            query::CreateContactsList,
            query::DeleteContactsList,
            query::GetSubscribedListIdsByOwner,
            query::GetTagById,
            query::GetContactIdsByListIds,
            query::PurgeContactsUser
        >(path);
}

using BaseQueryRepository = decltype(makeBaseQueryRepository(std::string()));

struct QueryRepository : BaseQueryRepository {};

inline auto makeQueryRepository(const std::string& path) {
    return QueryRepository {makeBaseQueryRepository(path)};
}

} // namespace collie::services::db
