#pragma once

#include "directory_entity_type.hpp"

#include <ozo/type_traits.h>

#include <cstdint>

namespace collie::services::db::contacts {

struct DirectoryEntity {
    std::int64_t id;
    collie::services::db::contacts::DirectoryEntityType type;
    std::int64_t contact_id;
};

} // namespace collie::services::db::contacts

OZO_PG_DEFINE_CUSTOM_TYPE(
    collie::services::db::contacts::DirectoryEntity,
    "code.directory_entity",
    dynamic_size
)
