#pragma once

#include "vcard_format.hpp"

#include <ozo/pg/types/jsonb.h>

namespace collie::services::db::contacts {

struct NewContact {
    std::int64_t list_id;
    VcardFormat format;
    ozo::pg::jsonb vcard;
    std::optional<std::string> uri;
};

} // namespace collie::services::db::contacts

OZO_PG_DEFINE_CUSTOM_TYPE(collie::services::db::contacts::NewContact, "code.new_contact", dynamic_size)
