#pragma once

#include "vcard_format.hpp"

#include <ozo/type_traits.h>
#include <ozo/pg/types/jsonb.h>

#include <string>

namespace collie::services::db::contacts {

struct UpdatedContact {
    std::int64_t contact_id;
    std::optional<std::int64_t> list_id;
    std::optional<VcardFormat> format;
    std::optional<ozo::pg::jsonb> vcard;
    std::optional<std::string> uri;
};

} // namespace collie::services::db::contacts

OZO_PG_DEFINE_CUSTOM_TYPE(collie::services::db::contacts::UpdatedContact, "code.updated_contact", dynamic_size)
