#pragma once

#include "uid_to_connection_resolve_operation.hpp"

#include <pgg/service/uid_resolver.h>

namespace collie::services::db::contacts {

template <typename EndpointPool>
class UidToConnectionResolver {
public:
    UidToConnectionResolver(
        std::int64_t uid,
        std::shared_ptr<EndpointPool> endpoints,
        ozo::connection_pool_timeouts timeouts,
        TaskContextPtr ctx,
        pgg::UidResolverPtr resolver)
     : uid(uid), endpoints(endpoints), timeouts(timeouts), ctx(ctx), resolver(resolver) {}

    using ConnectionPool = typename EndpointPool::ConnectionPool;

    template <typename Handler>
    void operator() (Handler&& handler) const {
        UidToConnectionResolveOperation<EndpointPool, Handler>{
            endpoints, timeouts, ctx, std::forward<Handler>(handler)
        }.perform(resolver, uid);
    }

private:
    std::int64_t uid;
    std::shared_ptr<EndpointPool> endpoints;
    ozo::connection_pool_timeouts timeouts;
    TaskContextPtr ctx;
    pgg::UidResolverPtr resolver;
};

} // namespace collie::services::db::contacts
