#pragma once

#include "query.hpp"

#include <src/services/db/connection_provider.hpp>
#include <src/services/db/utils.hpp>

#include <ozo/execute.h>
#include <ozo/shortcuts.h>

namespace collie::services::db::events_queue {

template <class P>
class CompleteSyncDirectoryEvent {
    static_assert(ConnectionProvider<P>);

public:
    CompleteSyncDirectoryEvent(P provider)
        : provider(std::move(provider)) {}

    template <class C>
    expected<void> operator ()(C& connection, query::CompleteSyncDirectoryEvent params) const {
        using ozo::execute;
        using ozo::to_const_char;
        using ozo::get_text;
        using ozo::get_error_context;

        const auto context = provider.context();
        const auto query = provider.queryRepository().template make_query<query::CompleteSyncDirectoryEvent>(std::move(params));
        ozo::error_code ec;
        connection = execute(connection, query, context->yield()[ec]);
        if (ec) {
            LOGDOG_(context->logger(), error,
                log::error_code=ec,
                log::query=to_const_char(get_text(query)),
                log::message=(connection ? get_error_context(connection) : std::string())
            );
            return make_unexpected(error_code(Error::databaseError));
        }
        return {};
    }

private:
    P provider;
};

} // namespace collie::services::db::events_queue
