#pragma once

#include "connection_pool.hpp"
#include "connection_adaptor.hpp"
#include "connection_provider_config.hpp"

#include <src/services/db/timeouts.hpp>
#include <src/get_io_context.hpp>
#include <src/task_context.hpp>

#include <ozo/connection_pool.h>

namespace collie::services::db::events_queue {

template <class MasterResolver>
class ConnectionProvider {
public:
    using connection_type = ConnectionAdaptor;

    ConnectionProvider(
        MasterResolver resolveMaster,
        const ConnectionProviderConfig& config,
        TaskContextPtr context)
        : resolveMaster(resolveMaster), config(config), context_(context) {}

    template <typename TimeConstraint, typename Handler>
    void async_get_connection(TimeConstraint, Handler&& handler) const {
        resolveMaster(adaptConnection(ConnectionContext {config, context_}, std::forward<Handler>(handler)));
    }

    auto requestTimeout() const {
        return config.timeouts.request;
    }

    auto maxRetriesNumber() const {
        return config.maxRetriesNumber;
    }

    TaskContextPtr context() const {
        return context_;
    }

    const QueryRepository& queryRepository() const {
        return config.queryRepository;
    }

private:
    MasterResolver resolveMaster;
    ConnectionProviderConfig config;
    TaskContextPtr context_;
};

} // namespace collie::services::db::events_queue
