#include "make_connection_provider.hpp"

namespace collie::services::db::events_queue {

MakeConnectionProvider::MakeConnectionProvider(const Config& config, GetHttpClient getHttpClient)
        : config {
            config.timeouts,
            config.maxRetriesNumber,
            makeQueryRepository(config.queryConf)
        },
        credentials(config.credentials),
        sharpeiClientSettings(config.sharpei.client),
        sharpeiHttpClient(std::make_shared<const sharpei::SharpeiHttpClient>(
            std::move(getHttpClient),
            config.sharpei.connectTimeout
        )),
        endpointPool(std::make_shared<EndpointPool>(
            config.maxTotalPoolsCapacity,
            config.connectionPool
        )) {
}

} // namespace collie::services::db::events_queue
