#pragma once

#include "config.hpp"
#include "connection_provider.hpp"
#include "endpoint_pool.hpp"
#include "master_resolver.hpp"

#include <src/services/sharpei/sharpei_http_client.hpp>

#include <pgg/service/shard_resolver.h>

namespace collie::services::db::events_queue {

class MakeConnectionProvider {
public:
    MakeConnectionProvider(const Config& config, GetHttpClient getHttpClient);

    auto operator ()(TaskContextPtr context) const {
        ::sharpei::client::RequestInfo requestInfo;
        requestInfo.requestId = context->requestId();
        requestInfo.clientType = context->clientType();
        requestInfo.userIp = context->userIp();
        requestInfo.uniqId = context->uniq_id();

        return ConnectionProvider(
            MasterResolver(
                ::sharpei::client::Shard::Id("1"),
                endpointPool,
                config.timeouts.connectionPool,
                pgg::createShardResolver(
                    credentials,
                    ::sharpei::client::createSharpeiClient(
                        sharpeiHttpClient, sharpeiClientSettings, requestInfo
                    )
                ),
                context
            ),
            config,
            context
        );
    }

private:
    ConnectionProviderConfig config;
    pgg::Credentials credentials;
    ::sharpei::client::Settings sharpeiClientSettings;
    sharpei::SharpeiHttpClientPtr sharpeiHttpClient;
    std::shared_ptr<EndpointPool> endpointPool;
};

} // namespace collie::services::db::events_queue
