#pragma once

#include "master_resolve_operation.hpp"

#include <pgg/service/shard_resolver.h>

namespace collie::services::db::events_queue {

template <typename EndpointPool>
class MasterResolver {
public:
    MasterResolver(
        ::sharpei::client::Shard::Id shardId,
        std::shared_ptr<EndpointPool> endpoints,
        ozo::connection_pool_timeouts timeouts,
        pgg::ShardResolverPtr resolver,
        TaskContextPtr context)
        : shardId(std::move(shardId)), endpoints(endpoints), timeouts(timeouts),
          resolver(resolver), context(context) {
    }

    using ConnectionPool = typename EndpointPool::ConnectionPool;

    template <typename Handler>
    void operator() (Handler&& handler) const {
        MasterResolveOperation<EndpointPool, Handler>{
            endpoints, timeouts, context, handler
        }.perform(resolver, shardId);
    }

private:
    ::sharpei::client::Shard::Id shardId;
    std::shared_ptr<EndpointPool> endpoints;
    ozo::connection_pool_timeouts timeouts;
    pgg::ShardResolverPtr resolver;
    TaskContextPtr context;
};

} // namespace collie::services::db::events_queue
