#pragma once

#include "types/id_map_element.hpp"
#include "types/service_type.hpp"
#include "types/event_type.hpp"

#include <src/services/db/org_user_id.hpp>

#include <ozo/type_traits.h>

#include <vector>

namespace collie::services::db::events_queue {

using BaseOidMap = decltype(ozo::register_types<
        OrgUserId,
        ServiceType,
        IdMapElement,
        std::vector<IdMapElement>,
        EventType
    >());

struct OidMap : BaseOidMap {};

} // namespace collie::services::db::events_queue

namespace ozo {

template <>
struct is_oid_map<collie::services::db::events_queue::OidMap> : std::true_type {};

} // namespace ozo
