#pragma once

#include "types/reflection/id_map_element.hpp"
#include "types/reflection/service_sync_timestamp_row.hpp"
#include "types/reflection/user_to_sync.hpp"
#include "types/directory_event_id.hpp"
#include "types/directory_revision.hpp"
#include "types/service_type.hpp"
#include "types/event_type.hpp"

#include <src/services/db/org_user_id.hpp>

#include <ozo/query_conf.h>

#include <boost/hana/define_struct.hpp>
#include <boost/hana/string.hpp>

namespace collie::services::db::events_queue::query {

using namespace boost::hana::literals;

struct GetUserToSyncByEventsCount {
    static constexpr auto name = "GetUserToSyncByEventsCount"_s;

    BOOST_HANA_DEFINE_STRUCT(GetUserToSyncByEventsCount);

    using parameters_type = GetUserToSyncByEventsCount;
    using result_type = UserToSync;
};

struct GetUserToSyncByLastSyncDate {
    static constexpr auto name = "GetUserToSyncByLastSyncDate"_s;

    BOOST_HANA_DEFINE_STRUCT(GetUserToSyncByLastSyncDate,
        (std::int64_t, sync_interval_in_minutes)
    );

    using parameters_type = GetUserToSyncByLastSyncDate;
    using result_type = UserToSync;
};

struct CompleteSyncDirectoryEvent {
    static constexpr auto name = "CompleteSyncDirectoryEvent"_s;

    BOOST_HANA_DEFINE_STRUCT(CompleteSyncDirectoryEvent,
        (OrgUserId, user_id),
        (DirectoryRevision, synced_revision),
        (DirectoryEventId, synced_event_id)
    );

    using parameters_type = CompleteSyncDirectoryEvent;
    using result_type = void;
};

struct CompleteDirectoryOrganizationRemoval {
    static constexpr auto name = "CompleteDirectoryOrganizationRemoval"_s;

    BOOST_HANA_DEFINE_STRUCT(CompleteDirectoryOrganizationRemoval,
        (OrgUserId, user_id)
    );

    using parameters_type = CompleteDirectoryOrganizationRemoval;
    using result_type = void;
};

struct AddDirectoryEvents {
    friend constexpr auto get_raw_query_name(const AddDirectoryEvents&) noexcept {
        return "AddDirectoryEvents"_s;
    }

    BOOST_HANA_DEFINE_STRUCT(AddDirectoryEvents,
        (OrgUserId, user_id),
        (std::int64_t, event_count),
        (EventType, event_type),
        (std::int64_t, event_revision)
    );

    using parameters_type = AddDirectoryEvents;
    using result_type = void;
};

struct AddDirectoryEvent {
    friend constexpr auto get_raw_query_name(const AddDirectoryEvent&) noexcept {
        return "AddDirectoryEvent"_s;
    }

    BOOST_HANA_DEFINE_STRUCT(AddDirectoryEvent,
        (OrgUserId, user_id)
    );

    using parameters_type = AddDirectoryEvent;
    using result_type = void;
};

struct AddDirectoryEventForUsers {
    friend constexpr auto get_raw_query_name(const AddDirectoryEventForUsers&) noexcept {
        return "AddDirectoryEventForUsers"_s;
    }

    BOOST_HANA_DEFINE_STRUCT(AddDirectoryEventForUsers,
        (std::vector<OrgUserId>, user_ids)
    );

    using parameters_type = AddDirectoryEventForUsers;
    using result_type = void;
};

struct GetServiceSyncTimestamp {
    friend constexpr auto get_raw_query_name(const GetServiceSyncTimestamp&) noexcept {
        return "GetServiceSyncTimestamp"_s;
    }

    BOOST_HANA_DEFINE_STRUCT(GetServiceSyncTimestamp,
        (ServiceType, service_type)
    );

    using parameters_type = GetServiceSyncTimestamp;
    using result_type = ServiceSyncTimestampRow;
};

struct SetServiceSyncTimestamp {
    friend constexpr auto get_raw_query_name(const SetServiceSyncTimestamp&) noexcept {
        return "SetServiceSyncTimestamp"_s;
    }

    BOOST_HANA_DEFINE_STRUCT(SetServiceSyncTimestamp,
        (ServiceType, service_type)
    );

    using parameters_type = SetServiceSyncTimestamp;
    using result_type = void;
};

struct AddStaffIdMapElements {
    friend constexpr auto get_raw_query_name(const AddStaffIdMapElements&) noexcept {
        return "AddStaffIdMapElements"_s;
    }

    BOOST_HANA_DEFINE_STRUCT(AddStaffIdMapElements,
        (std::vector<IdMapElement>, elements)
    );

    using parameters_type = AddStaffIdMapElements;
    using result_type = void;
};

struct DeleteContactIdsByStaffIds {
    friend constexpr auto get_raw_query_name(const DeleteContactIdsByStaffIds&) noexcept {
        return "DeleteContactIdsByStaffIds"_s;
    }

    BOOST_HANA_DEFINE_STRUCT(DeleteContactIdsByStaffIds,
        (std::vector<KeyId>, ids)
    );

    using parameters_type = DeleteContactIdsByStaffIds;
    using result_type = void;
};

struct GetStaffIdMapElements {
    friend constexpr auto get_raw_query_name(const GetStaffIdMapElements&) noexcept {
        return "GetStaffIdMapElements"_s;
    }

    BOOST_HANA_DEFINE_STRUCT(GetStaffIdMapElements
    );

    using parameters_type = GetStaffIdMapElements;
    using result_type = IdMapElement;
};

struct AddMlIdMapElements {
    friend constexpr auto get_raw_query_name(const AddMlIdMapElements&) noexcept {
        return "AddMlIdMapElements"_s;
    }

    BOOST_HANA_DEFINE_STRUCT(AddMlIdMapElements,
        (std::vector<IdMapElement>, elements)
    );

    using parameters_type = AddMlIdMapElements;
    using result_type = void;
};

struct DeleteContactIdsByMlIds {
    friend constexpr auto get_raw_query_name(const DeleteContactIdsByMlIds&) noexcept {
        return "DeleteContactIdsByMlIds"_s;
    }

    BOOST_HANA_DEFINE_STRUCT(DeleteContactIdsByMlIds,
        (std::vector<KeyId>, ids)
    );

    using parameters_type = DeleteContactIdsByMlIds;
    using result_type = void;
};

struct GetMlIdMapElements {
    friend constexpr auto get_raw_query_name(const GetMlIdMapElements&) noexcept {
        return "GetMlIdMapElements"_s;
    }

    BOOST_HANA_DEFINE_STRUCT(GetMlIdMapElements
    );

    using parameters_type = GetMlIdMapElements;
    using result_type = IdMapElement;
};

} // namespace collie::services::db::events_queue::query
