#pragma once

#include "query.hpp"

#include <src/services/db/query_repository.hpp>

namespace collie::services::db::events_queue {

inline auto makeBaseQueryRepository(const std::string& path) {
    return db::makeQueryRepository<
            query::GetUserToSyncByEventsCount,
            query::GetUserToSyncByLastSyncDate,
            query::CompleteSyncDirectoryEvent,
            query::CompleteDirectoryOrganizationRemoval,
            query::AddDirectoryEvents,
            query::AddDirectoryEvent,
            query::AddDirectoryEventForUsers,
            query::GetServiceSyncTimestamp,
            query::SetServiceSyncTimestamp,
            query::AddStaffIdMapElements,
            query::DeleteContactIdsByStaffIds,
            query::GetStaffIdMapElements,
            query::AddMlIdMapElements,
            query::DeleteContactIdsByMlIds,
            query::GetMlIdMapElements
        >(path);
}

using BaseQueryRepository = decltype(makeBaseQueryRepository(std::string()));

struct QueryRepository : BaseQueryRepository {};

inline auto makeQueryRepository(const std::string& path) {
    return QueryRepository {makeBaseQueryRepository(path)};
}

} // namespace collie::services::db::events_queue
