#pragma once

#include <boost/fusion/adapted/struct/define_struct.hpp>

#include <src/services/db/org_user_id.hpp>
#include <src/services/db/events_queue/types/event_type.hpp>

BOOST_FUSION_DEFINE_STRUCT((collie)(services)(db)(events_queue), UserToSync,
    (collie::services::db::OrgUserId, user_id)
    (std::int64_t, synced_event_id)
    (std::int64_t, synced_revision)
    (std::optional<collie::services::db::events_queue::EventType>, event_type)
)
